/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render.context_management;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Stack;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.ducks.IECamera;

public class WorldRenderInfo {
    public final ClientLevel world;
    public final Vec3 cameraPos;
    public final boolean overwriteCameraTransformation;
    @Nullable
    public final Matrix4f cameraTransformation;
    @Nullable
    public final UUID description;
    public final int renderDistance;
    public final boolean doRenderHand;
    public final boolean enableViewBobbing;
    public final boolean doRenderSky;
    public final boolean hasFog;
    @Nullable
    public final IsometricParameters isometricParameters;
    private static final Stack<WorldRenderInfo> renderInfoStack = new Stack();
    @Nullable
    private static List<UUID> renderingDescCache = null;

    @Deprecated
    public WorldRenderInfo(ClientLevel world, Vec3 cameraPos, @Nullable Matrix4f cameraTransformation, boolean overwriteCameraTransformation, @Nullable UUID description, int renderDistance) {
        this(world, cameraPos, cameraTransformation, overwriteCameraTransformation, description, renderDistance, false);
    }

    @Deprecated
    public WorldRenderInfo(ClientLevel world, Vec3 cameraPos, @Nullable Matrix4f cameraTransformation, boolean overwriteCameraTransformation, @Nullable UUID description, int renderDistance, boolean doRenderHand) {
        this.world = world;
        this.cameraPos = cameraPos;
        this.cameraTransformation = cameraTransformation;
        this.description = description;
        this.renderDistance = renderDistance;
        this.overwriteCameraTransformation = overwriteCameraTransformation;
        this.doRenderHand = doRenderHand;
        this.enableViewBobbing = true;
        this.doRenderSky = true;
        this.isometricParameters = null;
        this.hasFog = true;
    }

    @Deprecated
    public WorldRenderInfo(ClientLevel world, Vec3 cameraPos, @Nullable Matrix4f cameraTransformation, boolean overwriteCameraTransformation, @Nullable UUID description, int renderDistance, boolean doRenderHand, boolean enableViewBobbing) {
        this.world = world;
        this.cameraPos = cameraPos;
        this.cameraTransformation = cameraTransformation;
        this.description = description;
        this.renderDistance = renderDistance;
        this.overwriteCameraTransformation = overwriteCameraTransformation;
        this.doRenderHand = doRenderHand;
        this.enableViewBobbing = enableViewBobbing;
        this.doRenderSky = true;
        this.isometricParameters = null;
        this.hasFog = true;
    }

    private WorldRenderInfo(ClientLevel world, Vec3 cameraPos, @Nullable Matrix4f cameraTransformation, boolean overwriteCameraTransformation, @Nullable UUID description, int renderDistance, boolean doRenderHand, boolean enableViewBobbing, boolean doRenderSky, boolean hasFog, @Nullable IsometricParameters isometricParameters) {
        this.world = world;
        this.cameraPos = cameraPos;
        this.cameraTransformation = cameraTransformation;
        this.description = description;
        this.renderDistance = renderDistance;
        this.overwriteCameraTransformation = overwriteCameraTransformation;
        this.doRenderHand = doRenderHand;
        this.enableViewBobbing = enableViewBobbing;
        this.doRenderSky = doRenderSky;
        this.hasFog = hasFog;
        this.isometricParameters = isometricParameters;
    }

    public static void pushRenderInfo(WorldRenderInfo worldRenderInfo) {
        renderInfoStack.push(worldRenderInfo);
        renderingDescCache = null;
    }

    public static void popRenderInfo() {
        renderInfoStack.pop();
        renderingDescCache = null;
    }

    public static void adjustCameraPos(Camera camera) {
        if (!renderInfoStack.isEmpty()) {
            WorldRenderInfo currWorldRenderInfo = WorldRenderInfo.getTopRenderInfo();
            ((IECamera)camera).portal_setPos(currWorldRenderInfo.cameraPos);
        }
    }

    public static void applyAdditionalTransformations(PoseStack matrixStack) {
        for (WorldRenderInfo worldRenderInfo : renderInfoStack) {
            Matrix4f matrix;
            if (worldRenderInfo.overwriteCameraTransformation) {
                matrixStack.m_85850_().m_252922_().identity();
                matrixStack.m_85850_().m_252943_().identity();
            }
            if ((matrix = worldRenderInfo.cameraTransformation) == null) continue;
            matrixStack.m_85850_().m_252922_().mul((Matrix4fc)matrix);
            Matrix3f normalMatrixMult = new Matrix3f((Matrix4fc)matrix);
            normalMatrixMult.scale((float)Math.pow(1.0 / (double)Math.abs(normalMatrixMult.determinant()), 0.3333333333333333));
            matrixStack.m_85850_().m_252943_().mul((Matrix3fc)normalMatrixMult);
        }
    }

    public static boolean isRendering() {
        return !renderInfoStack.empty();
    }

    public static int getRenderingLayer() {
        return renderInfoStack.size();
    }

    public static List<UUID> getRenderingDescription() {
        if (renderingDescCache == null) {
            renderingDescCache = renderInfoStack.stream().map(renderInfo -> renderInfo.description).collect(Collectors.toList());
        }
        return renderingDescCache;
    }

    public static int getRenderDistance() {
        if (renderInfoStack.isEmpty()) {
            return Minecraft.m_91087_().f_91066_.m_193772_();
        }
        return WorldRenderInfo.getTopRenderInfo().renderDistance;
    }

    public static WorldRenderInfo getTopRenderInfo() {
        return renderInfoStack.peek();
    }

    public static Vec3 getCameraPos() {
        Validate.isTrue((!renderInfoStack.isEmpty() ? 1 : 0) != 0);
        return WorldRenderInfo.getTopRenderInfo().cameraPos;
    }

    public static boolean isViewBobbingEnabled() {
        return renderInfoStack.stream().allMatch(info -> info.enableViewBobbing);
    }

    public static boolean isFogEnabled() {
        if (IPGlobal.debugDisableFog) {
            return false;
        }
        if (WorldRenderInfo.isRendering()) {
            return WorldRenderInfo.getTopRenderInfo().hasFog;
        }
        return true;
    }

    public record IsometricParameters() {
    }

    public static class Builder {
        private ClientLevel world;
        private Vec3 cameraPos;
        private Matrix4f cameraTransformation = null;
        private boolean overwriteCameraTransformation = true;
        private UUID description = null;
        private int renderDistance;
        private boolean doRenderHand;
        private boolean enableViewBobbing;
        private boolean doRenderSky;
        private boolean hasFog;
        @Nullable
        private IsometricParameters isometricParameters;

        public Builder() {
            this.renderDistance = Minecraft.m_91087_().f_91066_.m_193772_();
            this.doRenderHand = false;
            this.enableViewBobbing = true;
            this.doRenderSky = true;
            this.hasFog = true;
            this.isometricParameters = null;
        }

        public Builder setWorld(ClientLevel world) {
            this.world = world;
            return this;
        }

        public Builder setCameraPos(Vec3 cameraPos) {
            this.cameraPos = cameraPos;
            return this;
        }

        public Builder setCameraTransformation(Matrix4f cameraTransformation) {
            this.cameraTransformation = cameraTransformation;
            return this;
        }

        public Builder setOverwriteCameraTransformation(boolean overwriteCameraTransformation) {
            this.overwriteCameraTransformation = overwriteCameraTransformation;
            return this;
        }

        public Builder setDescription(UUID description) {
            this.description = description;
            return this;
        }

        public Builder setRenderDistance(int renderDistance) {
            this.renderDistance = renderDistance;
            return this;
        }

        public Builder setDoRenderHand(boolean doRenderHand) {
            this.doRenderHand = doRenderHand;
            return this;
        }

        public Builder setEnableViewBobbing(boolean enableViewBobbing) {
            this.enableViewBobbing = enableViewBobbing;
            return this;
        }

        public Builder setDoRenderSky(boolean doRenderSky) {
            this.doRenderSky = doRenderSky;
            return this;
        }

        public Builder setHasFog(boolean hasFog) {
            this.hasFog = hasFog;
            return this;
        }

        public Builder setIsometricParameters(@Nullable IsometricParameters isometricParameters) {
            this.isometricParameters = isometricParameters;
            return this;
        }

        public WorldRenderInfo build() {
            Validate.notNull((Object)this.world);
            Validate.notNull((Object)this.cameraPos);
            return new WorldRenderInfo(this.world, this.cameraPos, this.cameraTransformation, this.overwriteCameraTransformation, this.description, this.renderDistance, this.doRenderHand, this.enableViewBobbing, this.doRenderSky, this.hasFog, this.isometricParameters);
        }
    }
}

